from flask import jsonify
from functools import wraps
from flask_login import current_user


def json_response(success=True, message='', data=None):
    resp = {'success': success, 'message': message}
    if data is not None:
        resp['data'] = data
    return jsonify(resp)


def admin_required(f):
    @wraps(f)
    def decorated_function(*args, **kwargs):
        if not current_user.is_authenticated or current_user.role != 'admin':
            return jsonify({'success': False, 'message': '管理员权限不足'}), 403
        return f(*args, **kwargs)
    return decorated_function


def student_required(f):
    @wraps(f)
    def decorated_function(*args, **kwargs):
        if not current_user.is_authenticated or current_user.role != 'student':
            return jsonify({'success': False, 'message': '学生权限不足'}), 403
        return f(*args, **kwargs)
    return decorated_function
