-- 创建数据库
CREATE DATABASE IF NOT EXISTS student_course CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE student_course;

-- 创建 users 表
CREATE TABLE IF NOT EXISTS users (
  id INT PRIMARY KEY AUTO_INCREMENT,
  username VARCHAR(50) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  role ENUM('student','admin') NOT NULL,
  email VARCHAR(100),
  full_name VARCHAR(100),
  created_at DATETIME NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 插入演示数据 users
INSERT INTO users (username, password_hash, role, email, full_name, created_at) VALUES
('admin1', '$2b$12$u1q9Zb1kX9v3jF0Y7q7k8Oqv6zXq0v7cXjQz0v7cXjQz0v7cXjQz0', 'admin', 'admin1@example.com', '管理员一', NOW()),
('student1', '$2b$12$u1q9Zb1kX9v3jF0Y7q7k8Oqv6zXq0v7cXjQz0v7cXjQz0v7cXjQz0', 'student', 'student1@example.com', '学生一', NOW());

-- 密码均为 "password"，使用 bcrypt 加密

-- 创建 courses 表
CREATE TABLE IF NOT EXISTS courses (
  id INT PRIMARY KEY AUTO_INCREMENT,
  course_code VARCHAR(20) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL,
  description TEXT,
  credits INT NOT NULL,
  teacher VARCHAR(100),
  capacity INT NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 插入演示数据 courses
INSERT INTO courses (course_code, name, description, credits, teacher, capacity) VALUES
('CS101', '计算机基础', '计算机科学入门课程', 3, '张老师', 50),
('MATH201', '高等数学', '微积分与线性代数', 4, '李老师', 60);

-- 创建 enrollments 表
CREATE TABLE IF NOT EXISTS enrollments (
  id INT PRIMARY KEY AUTO_INCREMENT,
  student_id INT NOT NULL,
  course_id INT NOT NULL,
  enroll_date DATETIME NOT NULL,
  status ENUM('enrolled','dropped') NOT NULL,
  FOREIGN KEY (student_id) REFERENCES users(id) ON DELETE CASCADE,
  FOREIGN KEY (course_id) REFERENCES courses(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 插入演示数据 enrollments
INSERT INTO enrollments (student_id, course_id, enroll_date, status) VALUES
(2, 1, NOW(), 'enrolled'),
(2, 2, NOW(), 'enrolled');

-- 创建 grades 表
CREATE TABLE IF NOT EXISTS grades (
  id INT PRIMARY KEY AUTO_INCREMENT,
  enrollment_id INT NOT NULL,
  grade VARCHAR(5),
  updated_at DATETIME,
  FOREIGN KEY (enrollment_id) REFERENCES enrollments(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 插入演示数据 grades
INSERT INTO grades (enrollment_id, grade, updated_at) VALUES
(1, 'A', NOW()),
(2, 'B+', NOW());
