# student_course 项目说明

## 项目简介

student_course 是一个基于 Flask 的学生选课系统，支持用户注册登录、课程管理、选课退课、成绩查询等功能，包含学生和管理员两种角色。

## 技术栈

- 后端：Python 3.8+，Flask
- 前端：HTML5, CSS3, JavaScript
- 数据库：MySQL

## 目录结构

```
student_course/
├── app.py
├── config.py
├── database.sql
├── requirements.txt
├── README.md
├── static/
│   ├── css/
│   │   └── style.css
│   └── js/
│       └── main.js
├── templates/
│   ├── base.html
│   ├── index.html
│   ├── register.html
│   ├── courses.html
│   ├── my_courses.html
│   ├── grades.html
│   ├── admin_courses.html
│   └── profile.html
└── utils.py
```

## 环境依赖

- Python 3.8+
- MySQL 5.7+

依赖库见 requirements.txt

## 安装步骤

1. 克隆项目

```bash
git clone <项目地址>
cd student_course
```

2. 创建并激活虚拟环境（推荐）

```bash
python3 -m venv venv
source venv/bin/activate  # Linux/macOS
venv\Scripts\activate  # Windows
```

3. 安装依赖

```bash
pip install -r requirements.txt
```

4. 初始化数据库

- 确保 MySQL 服务已启动
- 使用 MySQL 客户端执行 `database.sql` 文件

```bash
mysql -u root -p < database.sql
```

5. 修改 `config.py` 中的数据库连接配置（如果需要）

6. 启动服务

```bash
python app.py
```

7. 访问前端页面

- 访问首页：http://127.0.0.1:5000/

## API 调用示例

- 用户注册

```bash
curl -X POST http://127.0.0.1:5000/api/register \
-H "Content-Type: application/json" \
-d '{"username":"student1","password":"123456","email":"student1@example.com","full_name":"学生一","role":"student"}'
```

- 用户登录

```bash
curl -X POST http://127.0.0.1:5000/api/login \
-H "Content-Type: application/json" \
-d '{"username":"student1","password":"123456"}'
```

- 获取课程列表

```bash
curl http://127.0.0.1:5000/api/courses
```

## 备注

- 管理员账号示例：
  - username: admin1
  - password: admin123

- 学生账号示例：
  - username: student1
  - password: 123456


---

祝您使用愉快！
